% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddPCRclust.R
\name{calculateCPDs}
\alias{calculateCPDs}
\title{Calculates the copies per droplet}
\usage{
calculateCPDs(results, template = NULL, constantControl = NULL)
}
\arguments{
\item{results}{The result of the ddPCRclust algorithm.}

\item{template}{The parsed dataframe containing the template.}

\item{constantControl}{The constant refrence control, which should be present in each reaction. 
It is used to normalize the data.}
}
\value{
A list of lists, containing the counts for empty droplets, each marker with both total droplet count and CPD, 
and total number of droplets, for each element of the input list respectively.
}
\description{
This function takes the results of the clustering and calculates the actual counts per target, 
as well as the counts per droplet (CPD) for each marker.
}
\examples{
# Read files
exampleFiles <- list.files(paste0(find.package('ddPCRclust'), '/extdata'), full.names = TRUE)
files <- readFiles(exampleFiles[3])
# To read all example files uncomment the following line
# files <- readFiles(exampleFiles[1:8])

# Read template
template <- readTemplate(exampleFiles[9])

# Run ddPCRclust
result <- ddPCRclust(files, template)

# Calculate the CPDs
markerCPDs <- calculateCPDs(result, template$template)

}
