% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe-class.R
\name{overlap_df}
\alias{overlap_df}
\alias{overlap_df,Recipe-method}
\alias{overlap_df,PrepRecipe-method}
\title{Overlap of significant OTUs between tested methods.}
\usage{
overlap_df(rec, steps = steps_ids(rec, "da"), type = "all")

\S4method{overlap_df}{Recipe}(rec, steps = steps_ids(rec, "da"), type = "all")

\S4method{overlap_df}{PrepRecipe}(rec, steps = steps_ids(rec, "da"), type = "all")
}
\arguments{
\item{rec}{A \code{Recipe} object.}

\item{steps}{Character vector with step_ids to take in account.}

\item{type}{Indicates whether to use all taxa ("all") or only those that are
differentially abundant in at least one method ("da"). Default as "all".}
}
\value{
df
}
\description{
Overlap of significant OTUs between tested methods.
}
\examples{
data(test_prep_rec)

## Running the function returns a UpSet plot ordered by frequency.
df <- overlap_df(test_prep_rec, steps_ids(test_prep_rec, "da"))
head(df)

## If you want to exclude a method for the plot, you can remove it with the
## step parameter. In the following example we eliminate from the graph the
## results of maaslin
overlap_df(test_prep_rec, steps = steps_ids(test_prep_rec, "da")[-1])

## overlap_df function needs a prep-Recipe. If you pass a a non-prep
## Recipe the output is an error.
data(test_rec)
err <- testthat::expect_error(overlap_df(test_rec))
err
}
