% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browse_igv_regions.R
\name{browse_igv_regions}
\alias{browse_igv_regions}
\title{Interactive IGV visualisation (Shiny + igvShiny) of differential regions}
\usage{
browse_igv_regions(
  diff_results,
  samples = NULL,
  colour_cond1 = "#ff6600",
  colour_cond2 = "#2288dd",
  use_genome = NULL,
  padding_width = 20000,
  trackHeight = 65,
  peakColour = "darkgreen",
  trackColour = "#6666ff",
  host = "localhost",
  port = NULL
)
}
\arguments{
\item{diff_results}{A `DamIDResults` object, as returned by
`differential_binding()` or `differential_accessibility()`.}

\item{samples}{Optional character vector of sample names to display (default: all in dataset).}

\item{colour_cond1, colour_cond2}{Colours for differentially enriched region tracks.}

\item{use_genome}{IGV genome name (inferred from peak annotations if not given).}

\item{padding_width}{Width to pad browser viewbox on either side of the peak (Default: 20000)}

\item{trackHeight}{Height of bedGraph tracks (Default: 65)}

\item{peakColour}{Colour for significant peaks track (Default: "darkgreen")}

\item{trackColour}{Colour for bedGraph tracks (Default: "#6666ff")}

\item{host}{Hostname for the server location (Default: "localhost").}

\item{port}{Port for connection (if NULL (default) the port is assigned by Shiny).}
}
\value{
Invisibly returns the Shiny app object created by `shinyApp()`.
}
\description{
Launches a Shiny app with an embedded IGV browser and an interactive table listing
differentially-bound regions (from `differential_binding()` or `differential_accessibility()` results).
Clicking on a region in the table will pan IGV to that locus. Sample coverage and region tracks are loaded as quantitative/annotation tracks.
A dedicated "Save as SVG" button is provided to export the current IGV view.
}
\examples{
\donttest{
# This example launches an interactive Shiny app and is not run by
# automated checks. It requires an internet connection for IGV.

.generate_example_results <- function() {
    mock_genes_gr <- GenomicRanges::GRanges(
        seqnames = S4Vectors::Rle("2L", 7),
        ranges = IRanges::IRanges(
            start = c(1000, 2000, 3000, 5000, 6000, 7000, 8000),
            end = c(1500, 2500, 3500, 5500, 6500, 7500, 20000000)
        ),
        gene_id = c("FBgn001", "FBgn002", "FBgn003", "FBgn004", "FBgn005", "FBgn006", "FBgn007"),
        gene_name = c("geneA", "geneB", "geneC", "geneD", "geneE", "geneF", "LargeTestGene")
    )
    data_dir <- system.file("extdata", package = "damidBind")
    loaded_data <- load_data_peaks(
        binding_profiles_path = data_dir,
        peaks_path = data_dir,
        ensdb_genes = mock_genes_gr,
        quantile_norm = TRUE
    )
    diff_results <- differential_binding(
        loaded_data,
        cond = c("L4 Neurons" = "L4",
                 "L5 Neurons" = "L5")
    )
    return(diff_results)
}
diff_results <- .generate_example_results()

# Launch the interactive browser (requires network access; uncomment to run)
# browse_igv_regions(diff_results)
}

}
