% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-DamIDResults.R
\name{analysisTable}
\alias{analysisTable}
\alias{analysisTable,DamIDResults-method}
\title{Access the differential binding analysis results}
\usage{
analysisTable(object)
}
\arguments{
\item{object}{A \code{DamIDResults} object.}
}
\value{
A \code{data.frame} with the full analysis results.
}
\description{
This function returns the full differential analysis table from the
  \code{DamIDResults} object.
}
\examples{
# Helper function to create a sample DamIDResults object for examples
.generate_example_results <- function() {
    analysis_df <- data.frame(
        logFC = c(2, -2, 0.1), P.Value = c(0.01, 0.01, 0.9), B = c(4, 3, -1),
        gene_name = c("GeneA", "GeneB", "GeneC"),
        row.names = c("chr1:1-100", "chr1:101-200", "chr1:201-300")
    )
    new("DamIDResults",
        analysis = analysis_df,
        upCond1 = analysis_df[1, , drop = FALSE],
        upCond2 = analysis_df[2, , drop = FALSE],
        cond = c("Condition 1" = "C1", "Condition 2" = "C2"),
        data = list(test_category = "bound")
    )
}
mock_results <- .generate_example_results()
analysisTable(mock_results)
}
\seealso{
\code{\link{DamIDResults-class}} for an overview of the class and all its methods.
}
