% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ensdb_genes.R
\name{get_ensdb_genes}
\alias{get_ensdb_genes}
\title{Extract gene annotation from Ensembl via AnnotationHub EnsDb}
\usage{
get_ensdb_genes(
  organism_keyword = "drosophila melanogaster",
  genome_build = NULL,
  ensembl_version = NULL,
  exclude_biotypes = c("transposable_element", "pseudogene"),
  include_gene_metadata = c("gene_id", "gene_name")
)
}
\arguments{
\item{organism_keyword}{Character. Unique non-case-senstive string to search
for the organism (e.g., "drosophila melanogaster").}

\item{genome_build}{Optional character. Genome build identifier to further
restrict the EnsDb selection (e.g., "BDGP6").}

\item{ensembl_version}{Optional integer. Specific Ensembl version to fetch.
If NULL, the latest available version is used.}

\item{exclude_biotypes}{Character vector. Gene biotypes to exclude from the
result (default: c("transposable_element", "pseudogene")).}

\item{include_gene_metadata}{Character vector. Metadata columns to keep for
each gene (default: c("gene_id", "gene_name")).}
}
\value{
List with:
  \item{genes}{A GRanges object of genes (metadata columns per argument).}
  \item{ensembl_version}{Character. The Ensembl version string.}
  \item{genome_build}{Character. Genome build identifier.}
  \item{species}{Character. Latin binomial species name.}
  \item{common_name}{Character. Species common name.}
}
\description{
Retrieves gene information for a given organism from the most appropriate
Ensembl database hosted via Bioconductor's AnnotationHub and ensembldb.
}
\details{
This function queries AnnotationHub for EnsDb objects matching a supplied
organism keyword, with optional filtering by genome build and Ensembl version.
Genes matching excluded biotypes are filtered out. Only user-selected
metadata fields are retained in the genes output.
}
\examples{
if (isTRUE(curl::has_internet())) {
# This example requires an internet connection and will download data.
dm_genes <- get_ensdb_genes(
    organism_keyword = "drosophila melanogaster",
    ensembl_version = 110
)

# View the fetched genes GRanges object
dm_genes$genes
}

}
