% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noiseq_functions.R
\name{differential_accessibility}
\alias{differential_accessibility}
\title{Differential accessibility analysis for CATaDa (`NOISeq` based)}
\usage{
differential_accessibility(data_list, cond, regex = FALSE, norm = "n", q = 0.8)
}
\arguments{
\item{data_list}{List. Output from load_data_peaks.}

\item{cond}{A named or unnamed character vector of length two. The values are
strings or regular expressions used to identify samples for each condition.
If the vector is named, the names are used as user-friendly display names
for the conditions in plots and outputs. If unnamed, the match strings are
used as display names. The order determines the contrast, e.g., `cond[1]` vs `cond[2]`.}

\item{regex}{Logical. If `TRUE`, the strings in `cond` are treated as
regular expressions for matching sample names. If `FALSE` (the default),
fixed string matching is used.}

\item{norm}{Normalisation method passed to NOISeq.  Defaults to "n" (no normalisation), but "uqua"
(upper quantile) or "tmm" (trimmed mean of M) are options if needed}

\item{q}{Numeric. Q-value threshold for NOISeq significance (default 0.8).}
}
\value{
A `DamIDResults` object containing the results. Access slots using accessors (e.g., `analysisTable(results)`). The object includes:
  \item{upCond1}{data.frame of regions enriched in condition 1}
  \item{upCond2}{data.frame of regions enriched in condition 2}
  \item{analysis}{data.frame of full results for all tested regions}
  \item{cond}{A named character vector mapping display names to internal condition names}
  \item{data}{The original `data_list` input}
}
\description{
Setup and differential analysis for CATaDa chromatin accessibility experiments
using `NOISeq`. Accepts output from `load_data_peaks`, prepares a count matrix,
performs `NOISeq` analysis, and returns differentially-accessible loci.
}
\examples{
# NOTE: This example uses mock counts data, as the package's sample
# data is in log2-ratio format.

# Create a mock data_list with plausible count data
mock_occupancy_counts <- data.frame(
    name = c("peak1", "peak2", "peak3"),
    gene_name = c("GeneA", "GeneB", "GeneC"),
    gene_id = c("ID_A", "ID_B", "ID_C"),
    GroupA_rep1 = c(100, 20, 50), GroupA_rep2 = c(110, 25, 45),
    GroupB_rep1 = c(10, 200, 55), GroupB_rep2 = c(15, 220, 60),
    row.names = c("peak1", "peak2", "peak3")
)

mock_data_list <- list(
    occupancy = mock_occupancy_counts,
    test_category = "accessible"
)

# Run differential accessibility analysis
diff_access_results <- differential_accessibility(
    mock_data_list,
    cond = c("Group A" = "GroupA", "Group B" = "GroupB")
)

# View the results summary
diff_access_results

}
