% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/damidBind-package.R
\docType{package}
\name{damidBind-package}
\alias{damidBind}
\alias{damidBind-package}
\title{damidBind: Differential Binding Analysis for DamID-seq Data}
\description{
The damidBind package provides a streamlined workflow for determining
differential protein binding, RNA polymerase occupancy, or chromatin
accessibility from DamID-based sequencing experiments. It handles data loading,
processing, statistical analysis, and provides a suite of visualisation tools
for interpretation and exploration of the results.
}
\details{
The package is designed for three main experimental types:
\itemize{
  \item \strong{Transcription Factor Binding}: Analysis of conventional DamID or TaDa data to find differential binding sites for a protein of interest. Uses log-ratio data and the limma backend via \code{\link{differential_binding}}.
  \item \strong{Gene Transcription}: Analysis of RNA Polymerase II TaDa data to infer differential gene expression, analysed over gene bodies with \code{\link{load_data_genes}}.
  \item \strong{Chromatin Accessibility}: Analysis of CATaDa data to find differential accessibility. Uses count-based data and the NOIseq backend via \code{\link{differential_accessibility}}.
}

\strong{Core Workflow:}
\enumerate{
  \item \strong{Load Data:} Use \code{\link{load_data_peaks}} for TF binding/accessibility or \code{\link{load_data_genes}} for RNA Pol II occupancy. These functions read bedGraph and peak files, calculate occupancy scores, and annotate regions with nearby genes.
  \item \strong{Perform Differential Analysis:} Use \code{\link{differential_binding}} for conventional DamID log-ratio data (limma) or \code{\link{differential_accessibility}} for CATaDa count data (NOIseq). These return a \code{\linkS4class{DamIDResults}} object.
  \item \strong{Visualise and Explore:} Use the plotting functions on the `DamIDResults` object: \code{\link{plot_volcano}}, \code{\link{plot_venn}} and  \code{\link{analyse_go_enrichment}}; and the interactive \code{\link{browse_igv_regions}}  to browse differentially-bound regions in an interactive IGV browser window..
}

For a complete walkthrough, please see the package vignette by running:
`browseVignettes("damidBind")`
}
\seealso{
\strong{Primary Functions:}
\itemize{
  \item \code{\link{load_data_peaks}}: Load binding data and associated peak regions.
  \item \code{\link{load_data_genes}}: Load binding data summarised over gene bodies.
  \item \code{\link{differential_binding}}: Perform differential analysis for log-ratio data.
  \item \code{\link{differential_accessibility}}: Perform differential analysis for count-based data.
  \item \code{\linkS4class{DamIDResults}}: The main results object returned by analysis functions.
}

\strong{Useful links:}
\itemize{
  \item The damidBind vignette: `browseVignettes("damidBind")`
  \item Report bugs at \href{https://github.com/marshall-lab/damidBind/issues}{https://github.com/marshall-lab/damidBind/issues}
}
}
\author{
\strong{Maintainer}: Owen Marshall \email{owen.marshall@utas.edu.au} (\href{https://orcid.org/0000-0003-1605-3871}{ORCID})

}
\keyword{internal}
