% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatSequence.R
\name{formatSequence}
\alias{formatSequence}
\title{Format already aligned peptide sequences.}
\usage{
formatSequence(seq, proteome, upstreamOffset, downstreamOffset)
}
\arguments{
\item{seq}{A vector of aligned peptide sequences of the same length}

\item{proteome}{An object of \code{\link{Proteome-class}}.}

\item{upstreamOffset}{An integer, the upstream offset relative to
the anchoring position.}

\item{downstreamOffset}{An integer, the downstream offset relative
to the anchoring position.}
}
\value{
An object of \code{\link{dagPeptides-class}} Class
}
\description{
Convert already aligned peptide sequences into an object of 
\code{\link{dagPeptides-class}}.
}
\examples{
## Suppose you already have the aligned peptides sequences at hands. Then you can use 
## the formatSequence function to prepare an object of dagPeptides. Befor doing 
## that, you need prepare a Proteome object by the prepareProteome function.

dat <- unlist(read.delim(system.file(
                                   "extdata", "grB.txt", package = "dagLogo"),
                         header = FALSE, as.is = TRUE))
                         
## prepare an object of Proteome Class from a fasta file
proteome <- prepareProteome(fasta = system.file("extdata",
                                                "HUMAN.fasta",
                                                package = "dagLogo"), 
                            species = "Homo sapiens")
                            
## prepare an object of dagPeptides Class from a Proteome object
seq <- formatSequence(seq = dat, proteome = proteome, upstreamOffset = 14,
                     downstreamOffset = 15)

}
\author{
Jianhong Ou, Haibo Liu
}
