% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cytofHist.R
\name{cytofHist}
\alias{cytofHist}
\title{Returns histogram for grouped data}
\usage{
cytofHist(x, group, type = c("count", "density"), na.rm = FALSE, title = NULL)
}
\arguments{
\item{x}{Numeric vector of values that will be plotted.}

\item{group}{A vector that contains the grouping variable. It can be a 
numeric, factor, or character vector.}

\item{type}{Either "count" or "density". The "count" selection
keeps the groups on the same scale. The "density" option will
over emphasize the group with the fewest observations. This
is helpful when identifying where certain subgroups are relative
to the majority of the data.}

\item{na.rm}{TRUE if NAs should be removed prior to plotting.
FALSE if they should remain. The NAs will be plotted as a
separate group if they are not removed.}

\item{title}{Optional title for the plot}
}
\value{
A \code{ggplot2} histogram.
}
\description{
Returns histogram for grouped data
}
\examples{
data("raw_data", package = "CATALYST")
sce <- readCytof(raw_data, beads = 'Beads', viability = c('cisPt1','cisPt2'))
sce <- labelQC(sce)
cytofHist(scores(sce, 'bead'), label(sce))

}
