% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_number.R
\name{rowNumbers}
\alias{rowNumbers}
\title{returns the position of the cells below, above or between estimated gates}
\usage{
rowNumbers(flowframe, gates, ch)
}
\arguments{
\item{flowframe}{after debris are removed.}

\item{gates}{cut point between the identified clusters}

\item{ch}{gated channel}
}
\value{
a numeric vector
}
\description{
returns the position of the cells below, above or between estimated gates
}
\examples{
flowfile_path <- system.file("extdata", "B4_18_1.fcs", 
                  package = "cyanoFilter",
              mustWork = TRUE)
flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
                               transformation = FALSE, emptyValue = FALSE,
                               dataset = 1) 
flowfile_nona <- cyanoFilter::noNA(x = flowfile)
flowfile_noneg <- cyanoFilter::noNeg(x = flowfile_nona)
flowfile_logtrans <- cyanoFilter::lnTrans(x = flowfile_noneg, 
c('SSC.W', 'TIME'))
oneDgate(flowfile, 'RED.B.HLin')

}
