% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phytoFilterClass.R
\name{PhytopFilter}
\alias{PhytopFilter}
\title{the phytofilter class}
\usage{
PhytopFilter(
  fullflowframe,
  flowframe_proportion,
  clusters_proportion,
  particles_per_cluster,
  Cluster_ind,
  gated_channels,
  channels
)

PhytopFilter(
  fullflowframe,
  flowframe_proportion,
  clusters_proportion,
  particles_per_cluster,
  Cluster_ind,
  gated_channels,
  channels
)
}
\arguments{
\item{fullflowframe}{same as the input flowFrame}

\item{flowframe_proportion}{a partial flowframe containing containing a 
proportion of the measured particles}

\item{clusters_proportion}{number of margin particles measured}

\item{particles_per_cluster}{number of particles in each cluster}

\item{Cluster_ind}{labels for each cluster}

\item{gated_channels}{channels used for gating}

\item{channels}{all channels supplied}
}
\value{
object of class PhytoFilter
}
\description{
the phytofilter class

constructor for the PhytoFilter class
}
\section{Slots}{

\describe{
\item{\code{fullflowframe}}{object of class "flowFrame" same as the input flowFrame}

\item{\code{flowframe_proportion}}{object of class "flowFrame" a partial flowframe 
containing a proportion of the measured particles}

\item{\code{clusters_proportion}}{object of class "numeric" representing the 
proportion of particles in each cluster}

\item{\code{particles_per_cluster}}{object of class "data.frame" representing the 
number of particles in each cluster}

\item{\code{Cluster_ind}}{object of class "integer" representing the labels for each
cluster}

\item{\code{gated_channels}}{object of class "character" representing the names of
channels with multiple peaks}

\item{\code{channels}}{object of class "character" representing the names of the 
channels}
}}

\examples{
flowfile_path <- system.file("extdata", "B4_18_1.fcs", 
                 package = "cyanoFilter",
                 mustWork = TRUE)
flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
                               transformation = FALSE, emptyValue = FALSE,
                               dataset = 1)
flowfile_nona <- cyanoFilter::noNA(x = flowfile)
flowfile_noneg <- cyanoFilter::noNeg(x = flowfile_nona)
flowfile_logtrans <- lnTrans(x = flowfile_noneg, c('SSC.W', 'TIME'))
cellMargin(flowframe = flowfile_logtrans, Channel = 'SSC.W',
           type = 'estimate', y_toplot = "FSC.HLin")
           
flowfile_path <- system.file("extdata", "B4_18_1.fcs", 
                 package = "cyanoFilter",
                 mustWork = TRUE)
flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
                               transformation = FALSE, emptyValue = FALSE,
                               dataset = 1)
flowfile_nona <- cyanoFilter::noNA(x = flowfile)
flowfile_noneg <- cyanoFilter::noNeg(x = flowfile_nona)
flowfile_logtrans <- lnTrans(x = flowfile_noneg, c('SSC.W', 'TIME'))
cellMargin(flowframe = flowfile_logtrans, Channel = 'SSC.W',
           type = 'estimate', y_toplot = "FSC.HLin")
}
