% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustIndexes.R
\name{ClustIndexes}
\alias{ClustIndexes}
\title{Clustering the indexes applying K-means}
\usage{
ClustIndexes(x, scaling = TRUE)
}
\arguments{
\item{x}{list of expression data and their indexes after running
\code{\link{PreparingTheIndexes}}}

\item{scaling}{Boolean parameter, does the data should be standardized
before clustered. Default = TRUE}
}
\value{
list object is returned as output,
with the relative culstered indexes table in
 \emph{object$ClusteredIdxTable},
and the number of clusters for each index in \emph{object$optimalK}
}
\description{
Clustering each index, that was predifined by
\code{\link{PreparingTheIndexes}}, with \code{\link{kmeans}}.
}
\details{
The clustering is done with K-means. To choose an optimal k for
 K-means clustering, the Elbow method was applied, this method looks at the
 percentage of variance explained as a function of the number of clusters: the
 chosen number of clusters should be such that adding another cluster does
 not give much better modeling of the data. First, the ratio of the
 within-cluster sum of squares (WSS) to the total sum of squares (TSS) is
 computed for different values of k (i.e., 1, 2, 3 ...). The WSS, also known
 as sum of squared error (SSE), decreases as k gets larger. The Elbow method
 chooses the k at which the SSE decreases abruptly. This happens when the
 computed value of the WSS-to-TSS ratio first drops from 0.2.

 Running \code{\link{kmeans}} and calculating the optimal k for each one of
 the indexes in the data could take a long time. To shorten the procedure the
 user can skip this step altogether and directly view a specific index and
 its clusters by running either the \code{\link{PlotIndexesClust}} or the
 \code{\link{ctsGEShinyApp}} function.

 By default data is standardize before clustering,for clustering
 the raw counts set the \command{\strong{scaling}} parameter to FALSE.
}
\examples{

data_dir <- system.file("extdata", package = "ctsGE")
files <- dir(path=data_dir,pattern = "\\\\.xls$")
rts <- readTSGE(files, path = data_dir,
labels = c("0h","6h","12h","24h","48h","72h"), skip = 10625 )
prts <- PreparingTheIndexes(rts)

tsCI <- ClustIndexes(prts)

head(tsCI$ClusteredIdxTable) #the table with the clusterd indexes
head(tsCI$optimalK) #the table with the number of clusters for each index

}
\seealso{
\code{\link{kmeans}}, \code{\link{PlotIndexesClust}}
}

