% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_rho_and_var.R
\name{run_cor_bootstrap}
\alias{run_cor_bootstrap}
\title{Run bootstrapping of Spearman correlations within a dataset}
\usage{
run_cor_bootstrap(
  x,
  n_it = 20L,
  nThreads = 1L,
  verbose = TRUE,
  iterations_gap = 1L
)
}
\arguments{
\item{x}{Numeric matrix, the gene expression matrix to analyse.
Genes are in columns, samples are in rows.}

\item{n_it}{Integer, number of bootstrap iterations}

\item{nThreads}{Integer, number of threads to use for computations}

\item{verbose}{Logical, should progress be printed?}

\item{iterations_gap}{If output is verbose - Number of iterations between
each status message
(Default=1 - Displayed only if \code{verbose=TRUE})}
}
\value{
A list with two fields \describe{
\item{rho}{Numeric matrix constaining the bootstrapped
mean of the Spearman correlation between each column}
\item{var}{Numeric matrix constaining the bootstrapped
variance of the Spearman correlation between each column}
}
}
\description{
This function provides the more low-level functionality
of bootstrapping the Spearman correlations of the columns within a dataset.
Only use this function if you want
a low-level interface, else \code{\link{run_csd}}
provides a more streamlined approach if you want to do a CSD analysis.
}
\examples{
data("normal_expression")
cor_res <- run_cor_bootstrap(
    x = normal_expression,
    n_it = 100, nThreads = 2L
)
}
