% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize}
\alias{normalize}
\title{Normalization of ChIP-seq counts by input}
\usage{
normalize(
  metaData,
  condition,
  replicate,
  genome,
  mapq = 10,
  sequencing,
  input.free = FALSE,
  chroms = NULL,
  BPPARAM = BiocParallel::SerialParam()
)
}
\arguments{
\item{metaData}{A data frame containing all important information about the ChIP-seq experiments, i.e, for which histone modification they were conducted, 
path to the file, condition or replicate, path to control/input experiments.}

\item{condition}{The condition of the sample that is supposed to be normalized}

\item{replicate}{The replicate number of the sample that is supposed to be normalized}

\item{genome}{Reference genome. Either a character (one of: mm9, mm10, hg19, hg38) or a SeqInfo object}

\item{mapq}{Minimum mapping quality of the reads that should be included. Default is 10.}

\item{sequencing}{The type of sequencing that was used. Possible options are paired and single.}

\item{input.free}{[LOGICAL] Whether or not to run the function in the input free mode, in case there is no input experiment available. Default is FALSE.}

\item{chroms}{A vector of strings. Specify the relevant chromosomes if needed. Then, only the reads on these chromosomes are considered for normalization and used in further analysis. Default is 'all'.}

\item{BPPARAM}{An object of class SerialParam that is used as input for the BiocParallel functions.}
}
\value{
GRanges object containing the normalized counts
}
\description{
This function normalizes the ChIP-seq counts for the three histone modifications (H3K4me3, H3K4me1, H2K27ac) using an input experiment, 
as they are needed for the enhancer prediction in the next step. This step is optional, but recommended.
}
\details{
The function normalizes the ChIP-seq profiles of the three histone modifications using the counts of the provided control/input experiment:
First, the binned counts (bin size: 100bp) are computed for every target (H3K4me3, H3K4me1, H2K27ac, Input) with low-quality reads being fitlered.
Next, the counts of the histone modifications are normalized by input by forming the log2 fold change of the counts:
counts_norm(bin) = log2((counts_raw(bin) + 1)/(counts_input(bin) + 1)).
In case input experiments are not available, the input free mode will calculate the binned counts, 
but won't further normalize them.
}
\examples{

files <- c(system.file('extdata', 'Condition1.H3K4me1.bam', package='crupR'),
          system.file('extdata', 'Condition1.H3K4me3.bam', package='crupR'),
          system.file('extdata', 'Condition1.H3K27ac.bam', package='crupR'),
          system.file('extdata', 'Condition2.H3K4me1.bam', package='crupR'),
          system.file('extdata', 'Condition2.H3K4me3.bam', package='crupR'),
          system.file('extdata', 'Condition2.H3K27ac.bam', package='crupR'))

inputs <- c(rep(system.file('extdata', 'Condition1.Input.bam', package='crupR'), 3), 
           rep(system.file('extdata', 'Condition2.Input.bam', package='crupR'),3))
                                                       
metaData <- data.frame(HM = rep(c('H3K4me1','H3K4me3','H3K27ac'),2),
                      condition = c(1,1,1,2,2,2), replicate = c(1,1,1,1,1,1),
                      bamFile = files, inputFile = inputs)
                                            
normalize(metaData = metaData, condition = 1, replicate = 1,
    genome = 'mm10', sequencing = 'paired')

#Example for a customized genome:
genome = Seqinfo::Seqinfo(seqnames=c('chr3', 'chr4', 'chrM'),
                          seqlengths=c(1000, 2000, 500))

}
