\name{copynumberAccessors}
\alias{CA}
\alias{CB}
\alias{nuA}
\alias{nuB}
\alias{phiA}
\alias{phiB}
\alias{totalCopynumber}
\alias{rawCopynumber}

\title{

	Accessors for allele-specific or total copy number

}


\description{

These methods can be applied after an object of class \code{CNSet} has
been generated by the \code{crlmmCopynumber} function.

}
\usage{
CA(object, ...)
CB(object, ...)
nuA(object)
nuB(object)
phiA(object)
phiB(object)
totalCopynumber(object,...)
rawCopynumber(object,...)
}

\arguments{
  \item{object}{  An object of class \code{CNSet}.}
  \item{\dots}{
  An additional argument named 'i' can be passed to subset the markers
  and an argument 'j' can be passed to subset the samples.  Other
  arguments are ignored.
  }
}

\details{

	At polymorphic markers, nuA and nuB provide the intercept
	coefficient (the estimated background intensity) for the A and
	B alleles, respectively. phiA and phiB provide the slope
	coefficients for the A and B alleles, respectively.

	At nonpolymorphic markers, nuB and phiB are 'NA'.

	These functions can be used to tranlate the normalized
	intensities to the copy number scale.  Plotting the copy
	number estimates as a function of physical position can be
	used to guide downstream algorithms that smooth, as well as to
	assess possible mosaicism.


}

\value{

	nu[A/B] and phi[A/B] return matrices of the intercept and
	slope coefficients, respectively.

	CA and CB return matrices of allele-specific copy number.

	totalCopynumber (or rawCopynumber) returns a matrix of CA+CB.

      }

\note{

Subsetting the \code{CNSet} object before extracting copy number can be
very inefficient when the data set is very large, particularly if using
ff objects.  The \code{[} method will subset all of the assay data
elements and all of the elements in the LinearModelParameter slot.

}


\seealso{

	\code{\link{crlmmCopynumber}}, \code{\link{CNSet-class}}

}

\examples{
\dontrun{
data(cnSetExample)
all(isCurrent(cnSetExample)) ## is the cnSet object current?

## --------------------------------------------------
## calculating allele-specific copy number
## --------------------------------------------------
## copy number for allele A, first 5 markers, first 2 samples
(ca <- CA(cnSetExample, i=1:5, j=1:2))
## copy number for allele B, first 5 markers, first 2 samples
(cb <- CB(cnSetExample, i=1:5, j=1:2))
## total copy number for first 5 markers, first 2 samples
(cn1 <- ca+cb)

## total copy number at first 5 nonpolymorphic loci
index <- which(!isSnp(cnSetExample))[1:5]
cn2 <- CA(cnSetExample, i=index, j=1:2)
## note, cb is NA at nonpolymorphic loci
(cb <- CB(cnSetExample, i=index, j=1:2))
## note, ca+cb will give NAs at nonpolymorphic loci
CA(cnSetExample, i=index, j=1:2) + cb
## A shortcut for total copy number
cn3 <- totalCopynumber(cnSetExample, i=1:5, j=1:2)
all.equal(cn3, cn1)
cn4 <- totalCopynumber(cnSetExample, i=index, j=1:2)
all.equal(cn4, cn2)

## markers 1-5, all samples
cn5 <- totalCopynumber(cnSetExample, i=1:5)
## all markers, samples 1-5
cn6 <- totalCopynumber(cnSetExample, j=1:2)
}
}
\keyword{manip}

