% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeMultiGeneTargeting.R
\name{removeSpacersWithSecondaryTargets}
\alias{removeSpacersWithSecondaryTargets}
\title{Remove gRNAs targeting secondary targets}
\usage{
removeSpacersWithSecondaryTargets(
  guideSet,
  geneID,
  geneColumn = "gene_id",
  ignoreGenesWithoutSymbols = TRUE,
  ignoreReadthroughs = TRUE
)
}
\arguments{
\item{guideSet}{A \linkS4class{GuideSet} object.}

\item{geneID}{String specifying gene ID of the main gene target.}

\item{geneColumn}{Column in \code{geneAnnotation(guideSet)} specifying
gene IDs}

\item{ignoreGenesWithoutSymbols}{Should gene without gene symbols
be ignored when removing co-targeting gRNAs?}

\item{ignoreReadthroughs}{Should readthrough genes be ignored when 
removing co-targeting gRNAs?}
}
\value{
A \linkS4class{GuideSet} object with gRNAs targeting multiple
    targets removed.
}
\description{
Remove gRNAs targeting secondary targets
}
\details{
The protospacer target sequence of gRNAs can be located in 
   overlapping genes, and this function allows users to filter out such 
   gRNAs. This ensures remaining gRNAs are targeting only one gene.
}
\author{
Jean-Philippe Fortin
}
