% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTxInfoDataFrame.R
\name{getTxInfoDataFrame}
\alias{getTxInfoDataFrame}
\title{To obtain a DataFrame of transcript-specific CDS and mRNA coordinates}
\usage{
getTxInfoDataFrame(
  tx_id,
  txObject,
  bsgenome,
  extend = 30,
  checkCdsLength = TRUE
)
}
\arguments{
\item{tx_id}{String specifying ENSEMBL Transcript id.}

\item{txObject}{A \linkS4class{TxDb} object or a \linkS4class{GRangesList}
object obtained using \code{\link{TxDb2GRangesList}}.}

\item{bsgenome}{\linkS4class{BSgenome} object from which to extract
sequences if a \linkS4class{GRanges} object is provided as input.}

\item{extend}{Integer value specifying how many nucleotides in intron
regions should be included.}

\item{checkCdsLength}{Should the CDS nucleotide length be a multiple of 3?
TRUE by default.}
}
\value{
A \code{DataFrame} containing nucleotide and amino acid information.
The columns are:

\itemize{
\item \code{chr} Character specifying chromosome.
\item \code{pos} Integer value specifying coordinate in reference genome.
\item \code{strand} Character specifying strand of transcript.
\item \code{nuc} Character specifying nucleotide on the strand 
    specified by \code{strand}.
\item \code{aa} Character specifying amino acid.
\item \code{aa_number} Integer specifying amino acid number from 5' end.
\item \code{exon} Integer specifying exon number. 
\item \code{pos_plot} Integer specifying plot coordinate. Useful for
    plotting.
\item \code{pos_mrna} Integer specifying relative mRNA coordinate from the
    start of the mRNA.
\item \code{pos_cds} Integer specifying relative CDS coordinate from the
    start of the CDS.
\item \code{region} Character specifying gene region:
    3UTR, 5UTR, CDS, Intron, Upstream (promoter) or downstream. 
}
}
\description{
To obtain a DataFrame of transcript-specific CDS and mRNA
    coordinates.
}
\examples{

library(BSgenome.Hsapiens.UCSC.hg38)
bsgenome <- BSgenome.Hsapiens.UCSC.hg38
data("grListExample")
tx_id <- "ENST00000538872"
df <- getTxInfoDataFrame(tx_id=tx_id,
    txObject=grListExample,
    bsgenome=bsgenome)

}
\author{
Jean-Philippe Fortin
}
