% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/addGeneAnnotation.R
\name{addGeneAnnotation}
\alias{addGeneAnnotation}
\alias{addGeneAnnotation,GuideSet-method}
\alias{addGeneAnnotation,PairedGuideSet-method}
\title{Add gene context annotation to a \linkS4class{GuideSet} object}
\usage{
addGeneAnnotation(object, ...)

\S4method{addGeneAnnotation}{GuideSet}(
  object,
  txObject,
  anchor = c("cut_site", "pam_site", "editing_site"),
  ignore_introns = TRUE,
  ignore.strand = TRUE,
  addPfam = FALSE,
  mart_dataset = NULL
)

\S4method{addGeneAnnotation}{PairedGuideSet}(
  object,
  txObject,
  anchor = c("cut_site", "pam_site", "editing_site"),
  ignore_introns = TRUE,
  ignore.strand = TRUE,
  addPfam = FALSE,
  mart_dataset = NULL
)
}
\arguments{
\item{object}{A \linkS4class{GuideSet} object or a 
\linkS4class{PairedGuideSet} object.}

\item{...}{Additional arguments, currently ignored.}

\item{txObject}{A \linkS4class{TxDb} object or a
\linkS4class{GRangesList} object obtained using
\code{\link{TxDb2GRangesList}} to provide a 
gene model annotation.}

\item{anchor}{String specifying which relative coordinate
of gRNAs should be used to locate gRNAs within gene.
Must be either "cut_site", "pam_site" or "editing_site".}

\item{ignore_introns}{Should gene introns be ignored when annotating?
TRUE by default.}

\item{ignore.strand}{Should gene strand be ignored when annotating?
TRUE by default.}

\item{addPfam}{Should Pfam domains annotation be added?
FALSE by default. If set to TRUE, \pkg{biomaRt} must be installed.}

\item{mart_dataset}{String specifying dataset to be used by \pkg{biomaRt}
for Pfam domains annotation . E.g. "hsapiens_gene_ensembl".}
}
\value{
A \linkS4class{GuideSet} object with a "geneAnnotation" list column
    stored in \code{mcols(guideSet)}. See details section for a
    description of the different gene annotation columns.
}
\description{
Add gene context annotation to spacer sequence stored
    in a \linkS4class{GuideSet} object
}
\details{
For DNA-targeting nucleases, the different columns stored in
\code{mcols(guideSet)[["geneAnnotation"]]} are:

\itemize{
\item \code{tx_id} Transcript ID.
\item \code{gene_symbol} Gene symbol.
\item \code{gene_id} Gene ID.
\item \code{protein_id} Protein ID.
\item \code{ID} gRNA ID.
\item \code{pam_site} gRNA PAM site coordinate.
\item \code{cut_site} gRNA cut site coordinate.
\item \code{chr} gRNA chromosome name.
\item \code{strand} gRNA strand. 
\item \code{cut_cds} Is the gRNA cut site located within the coding sequence
    (CDS) of the targeted isoform?
\item \code{cut_fiveUTRs} Is the gRNA cut site located within the 5'UTR
    of the targeted isoform?
\item \code{cut_threeUTRs} Is the gRNA cut site located within the 3'UTR
    of the targeted isoform?
\item \code{cut_introns} Is the gRNA cut site located within an intron
    of the targeted isoform?
\item \code{percentCDS} Numeric value to indicate the relative position of 
   the cut site with respect to the start of the CDS sequence when
   \code{cut_cds} is \code{TRUE}. The relative position is expressed as 
   a percentage from the total length of the CDS.
\item \code{percentTx} Numeric value to indicate the relative position of 
   the cut site with respect to the start of the mRNA sequence
   (therefore including 5' UTR). The relative position is expressed as a
   percentage from the total length of the mRNA sequence.
\item \code{aminoAcidIndex} If \code{cut_cds} is \code{TRUE}, integer value
    indicating the amino acid index with respect to the start of the protein.
\item \code{downstreamATG} Number of potential reinitiation sites 
    (ATG codons) downstream of the gRNA cut site, within 85 amino acids.
\item \code{nIsoforms} Numeric value indicating the number of isoforms
    targeted by the gRNA.
\item \code{totalIsoforms} Numeric value indicating the total number of
    isoforms existing for the gene targeted by the gRNA and specified
    in \code{gene_id}.
\item \code{percentIsoforms} Numeric value indicating the percentage of 
    isoforms for the gene specified in \code{gene_id} targeted by the gRNA.
    Equivalent to \code{nIsoforms}/\code{totalIsoforms}*100.
\item \code{isCommonExon} Logical value to indicate whether or not the gRNA
    is targeing an exon common to all isoforms.
\item \code{nCodingIsoforms} Numeric value indicating the number of 
    coding isoforms targeted by the gRNA. 5' UTRs and 3' UTRs are excluded.
\item \code{totalCodingIsoforms} Numeric value indicating the total number of
    coding isoforms existing for the gene targeted by the gRNA and specified
    in \code{gene_id}.
\item \code{percentCodingIsoforms} Numeric value indicating the percentage
    of coding isoforms for the gene specified in \code{gene_id} targeted
    by the gRNA. Equivalent to
    \code{nCodingIsoforms}/\code{totalCodingIsoforms}*100.
    5' UTRs and 3' UTRs are excluded.
\item \code{isCommonCodingExon} Logical value to indicate whether or
    not the gRNA is targeing an exon common to all coding isoforms.
}
}
\examples{
data(guideSetExample, package="crisprDesign")
data(grListExample, package="crisprDesign")
guideSet <- addGeneAnnotation(guideSetExample[1:6],
                              txObject=grListExample)

# To access a gene annotation already added:
ann <- geneAnnotation(guideSet)

}
\seealso{
\code{\link{addTssAnnotation}} to add TSS annotation, and
    \code{\link{geneAnnotation}} to retrieve an existing gene annotation.
}
\author{
Jean-Philippe Fortin, Luke Hoberecht
}
