% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoupleRnival.R
\name{reduce_solution_network}
\alias{reduce_solution_network}
\title{reduce_solution_network}
\usage{
reduce_solution_network(
  decoupleRnival_res,
  meta_network,
  cutoff,
  upstream_input,
  RNA_input = NULL,
  n_steps = 10
)
}
\arguments{
\item{decoupleRnival_res}{A data frame resulting from the decoupleRnival function.}

\item{meta_network}{A network data frame containing signed directed prior knowledge of molecular interactions.}

\item{cutoff}{The consistency threshold for filtering edges from the solution network.}

\item{upstream_input}{A named vector with up_stream nodes and their corresponding activity.}

\item{RNA_input}{A named vector containing differential gene expression data.}

\item{n_steps}{The maximum number of steps from upstream input nodes to include in the solution network.}
}
\value{
A list containing the solution network (SIF) and an attribute table (ATT) with gene expression data.
}
\description{
Reduces a solution network based on a decoupling analysis of upstream and downstream gene expression,
by filtering out edges that do not meet a consistency threshold, and limiting the network to a
certain number of steps from upstream input nodes.
}
\examples{
# Example input data
upstream_input <- c("A" = 1, "B" = -1, "C" = 0.5)
downstream_input <- c("D" = 2, "E" = -1.5)
meta_network <- data.frame(
  source = c("A", "A", "B", "C", "C", "D", "E"),
  target = c("B", "D", "D", "E", "D", "B", "A"),
  interaction = c(-1, 1, -1, 1, -1, -1, 1)
)
RNA_input <- c("A" = 1, "B" = -1, "C" = 5, "D" = 0.7, "E" = -0.3)

# Run the decoupleRnival function to get the upstream influence scores
upstream_scores <- decoupleRnival(upstream_input, downstream_input, meta_network, n_layers = 2, n_perm = 100)

# Reduce the solution network based on the upstream influence scores
reduced_network <- reduce_solution_network(upstream_scores, meta_network, 0.4, upstream_input, RNA_input, 3)

# View the resulting solution network and attribute table
print(reduced_network$SIF)
print(reduced_network$ATT)
}
