% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_node_neighboorhood.R
\name{display_node_neighboorhood}
\alias{display_node_neighboorhood}
\title{display_node_neighboorhood}
\usage{
display_node_neighboorhood(central_node, sif, att, n = 100)
}
\arguments{
\item{central_node}{character or character vector; node ID(s) around which a 
network will be branched out untill meansurments and input are reached}

\item{sif}{df; COSMOS network solution in sif format like the first list
element returned by the format_cosmos_res function}

\item{att}{df; attributes of the nodes of the COMSOS network solution like 
the second list element returned by the format_cosmos_res function}

\item{n}{numeric; maximum number of steps in the network to look for inputs 
and measurments}
}
\value{
a visnetwork object
}
\description{
display input and measurements within n steps of a given set of nodes
}
\examples{
CARNIVAL_options <- cosmosR::default_CARNIVAL_options("lpSolve")
data(toy_network)
data(toy_signaling_input)
data(toy_metabolic_input)
data(toy_RNA)
test_for <- preprocess_COSMOS_signaling_to_metabolism(meta_network = toy_network,
signaling_data = toy_signaling_input,
metabolic_data = toy_metabolic_input,
diff_expression_data = toy_RNA,
maximum_network_depth = 15,
remove_unexpressed_nodes = TRUE,
CARNIVAL_options = CARNIVAL_options
)
test_result_for <- run_COSMOS_signaling_to_metabolism(data = test_for,
CARNIVAL_options = CARNIVAL_options)
test_result_for <- format_COSMOS_res(test_result_for)
network_plot <- display_node_neighboorhood(central_node = 'MYC',
sif = test_result_for[[1]],
att = test_result_for[[2]],
n = 7)
network_plot
}
