% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general-functions.R
\name{matchContTable}
\alias{matchContTable}
\title{Permute columns of a contingency table}
\usage{
matchContTable(table_1, table_2)
}
\arguments{
\item{table_1}{Partition from a first data clustering}

\item{table_2}{Partition from a second data clustering}
}
\value{
Permuted contingency table
}
\description{
Permute the columns of a contingency table comparing two clusterings
to load the diagonal as much as possible.
}
\examples{
## Generate arbitrary labels from two separate clustering results
labels_1 <- sample(1:10, 1000, replace=TRUE)  ## K=10 clusters
labels_2 <- sample(1:8, 1000, replace=TRUE)   ## K=8 clusters
matchContTable(labels_1, labels_2)

}
