% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulatePhyloPoissonLogNormal.R
\name{simulatePhyloPoissonLogNormal}
\alias{simulatePhyloPoissonLogNormal}
\title{Simulate Tree Structured Counts}
\usage{
simulatePhyloPoissonLogNormal(
  tree,
  log_means,
  log_variance_phylo,
  log_variance_sample,
  model.process = "BM",
  selection.strength = 0
)
}
\arguments{
\item{tree}{A phylogenetic tree with n tips.}

\item{log_means}{a matrix with the number of genes p rows and the number of
species n columns. Column names should match the tree taxa names.}

\item{log_variance_phylo}{a vector of length p of phylogenetic variances for 
the BM in the log space for each gene.}

\item{log_variance_sample}{a matrix of size p x n of environmental variances
for individual variations in the log space, for each gene and species.
Column names should match the tree taxa names.}
}
\value{
A list, with:
\describe{
\item{log_lambda}{the p x n matrix of log-lambda simulated by the BM on the tree.}
\item{counts}{the p x n matrix of counts with corresponding Poisson draws.}
}
}
\description{
Simulate a tree structured matrix of counts according to a Poisson-lognormal
model, with the log parameter of the poisson following a Brownian Motion (BM)
on the tree with noise.
}
\details{
For each gene, the log-lambda parameter evolves like a BM on the tree,
with an extra independent variance noise that can depend on the species.
Each gene has its own tree variance for the BM.
Each gene and each species has its own mean.
The counts for each gene and each species are then obtained as a Poisson draw
with a different lambda parameter, as generated by the BM.
}
\keyword{internal}
