% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-gt-freq.R
\name{plotGTFreq}
\alias{plotGTFreq}
\title{plotGTFreq}
\usage{
plotGTFreq(geno)
}
\arguments{
\item{geno}{the genotype data.frame of markers by samples from output of
function \code{correctGT}}
}
\value{
A ggplot object
}
\description{
Function to plot the genotypes for all samples faceted by genotype
}
\examples{

data(snp_geno)
or_geno <- snp_geno[,grep("X",colnames(snp_geno))]
rownames(or_geno) <- paste0(snp_geno$CHR,"_",snp_geno$POS)
or_geno[1,] <- rep("Fail",dim(or_geno)[2])
cr_geno <- correctGT(or_geno,ref = snp_geno$C57BL.6J,
                    alt = snp_geno$FVB.NJ..i.)
ft_gt <- filterGT(cr_geno)
plotGTFreq(ft_gt)
}
\author{
Ruqian Lyu
}
