% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-count.R
\name{plotCount}
\alias{plotCount}
\alias{plotCount,RangedSummarizedExperiment,missing,missing-method}
\alias{plotCount,RangedSummarizedExperiment,missing,character-method}
\alias{plotCount,RangedSummarizedExperiment,logical,character-method}
\alias{plotCount,RangedSummarizedExperiment,logical,missing-method}
\alias{plotCount,GRanges,logical,missing-method}
\alias{plotCount,GRanges,missing,missing-method}
\alias{plotCount,GRanges,missing,character-method}
\alias{plotCount,GRanges,logical,character-method}
\title{plotCount}
\usage{
plotCount(
  co_count,
  by_chr = FALSE,
  group_by = "sampleGroup",
  plot_type = "error_bar"
)

\S4method{plotCount}{RangedSummarizedExperiment,missing,missing}(
  co_count,
  by_chr = FALSE,
  group_by = "sampleGroup",
  plot_type = "error_bar"
)

\S4method{plotCount}{RangedSummarizedExperiment,missing,character}(
  co_count,
  by_chr = FALSE,
  group_by = "sampleGroup",
  plot_type = "error_bar"
)

\S4method{plotCount}{RangedSummarizedExperiment,logical,character}(
  co_count,
  by_chr = FALSE,
  group_by = "sampleGroup",
  plot_type = "error_bar"
)

\S4method{plotCount}{RangedSummarizedExperiment,logical,missing}(
  co_count,
  by_chr = FALSE,
  group_by = "sampleGroup",
  plot_type = "error_bar"
)

\S4method{plotCount}{GRanges,logical,missing}(
  co_count,
  by_chr = FALSE,
  group_by = "sampleGroup",
  plot_type = "error_bar"
)

\S4method{plotCount}{GRanges,missing,missing}(
  co_count,
  by_chr = FALSE,
  group_by = "sampleGroup",
  plot_type = "error_bar"
)

\S4method{plotCount}{GRanges,missing,character}(
  co_count,
  by_chr = FALSE,
  group_by = "sampleGroup",
  plot_type = "error_bar"
)

\S4method{plotCount}{GRanges,logical,character}(
  co_count,
  by_chr = FALSE,
  group_by = "sampleGroup",
  plot_type = "error_bar"
)
}
\arguments{
\item{co_count}{GRange or RangedSummarizedExperiment object, returned by \code{countCO}}

\item{by_chr, }{whether it should plot each chromosome separately}

\item{group_by, }{the column name in `colData(co_count)` that specify the
grouping factor. Or the character vector contains the unique prefix of
sample names that are used for defining different sample groups. If missing
all samples are assumed to be from one group}

\item{plot_type, }{determins what type the plot will be, choose from "error_bar"
or "hist". Only relevant when by_chr=TRUE}
}
\value{
ggplot object
}
\description{
Plot the number of COs per sample group or per chromosome
}
\examples{
demo_path <-paste0(system.file("extdata",package = "comapr"),"/")
s1_rse_state <- readHapState("s1",chroms=c("chr1"),
                             path=demo_path,barcodeFile=NULL,minSNP = 0,
                             minlogllRatio = 50,
                             bpDist = 100,maxRawCO=10,
                             minCellSNP = 0)
s1_count <- countCOs(s1_rse_state)
plotCount(s1_count)
}
