% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-mean-dp-track.R
\name{getMeanDPTrack}
\alias{getMeanDPTrack}
\title{getMeanDPTrack}
\usage{
getMeanDPTrack(
  chrom = "chr1",
  path_loc,
  nwindow = 80,
  sampleName,
  barcodeFile,
  plot_type = "hist",
  selectedBarcodes = NULL,
  snp_track = NULL,
  log = TRUE
)
}
\arguments{
\item{chrom}{the chromosome}

\item{path_loc}{the path prefix to the output files from sscocaller including
"*_totalCount.mtx" and "_altCount.mtx"}

\item{nwindow}{the number of windows for binning the chromosome}

\item{sampleName}{the sample name, which is the prefix of sscocaller's output
files}

\item{barcodeFile}{the barcode file containing the list of cell barcodes used
as the input file for sscocaller}

\item{plot_type, }{the DataTrack plot type, default to be `hist`}

\item{selectedBarcodes, }{the selected cell barcodes which should be the
barcodes that have been called crossovers for. If not supplied then all cells
are counted.}

\item{snp_track}{the SNP position track which is used for obtaining the SNP
chromosome locations. It could be omitted and the SNP positions will be acquired
from the "*_snpAnnot.txt" file.}

\item{log, }{whether the histogram of SNP density should be plotted on log
scale (log10)}
}
\value{
DataTrack object plotting the mean DP histogram for windowed
chromosomes
}
\description{
Generate the mean DP (Depth) DataTrack (from Gviz) for cells
}
\examples{
demo_path <-paste0(system.file("extdata",package = "comapr"),"/")
meanDP_track <- getMeanDPTrack(chrom ="chr1",
                               path_loc = demo_path,
                               sampleName = "s1",
                               barcodeFile = paste0(demo_path,
                                                    "s1_barcodes.txt"))

}
\author{
Ruqian Lyu
}
