% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCellCORange.R
\name{getCellCORange}
\alias{getCellCORange}
\title{getCellCORange}
\usage{
getCellCORange(co_count, cellBarcode)
}
\arguments{
\item{co_count, }{`GRanges` or `RangedSummarizedExperiment` object,}

\item{cellBarcode, }{the selected cell's barcode}
}
\value{
GRange object containing the crossover intervals for the selected
cell
}
\description{
It finds the crossover intervals for a selected cell
}
\examples{
  demo_path <-paste0(system.file("extdata",package = "comapr"),"/")
s1_rse_state <- readHapState("s1",chroms=c("chr1"),
                             path=demo_path,barcodeFile=NULL,minSNP = 0,
                             minlogllRatio = 50,
                             bpDist = 100,maxRawCO=10,
                             minCellSNP = 0)
s1_counts <- countCOs(s1_rse_state)

co_ranges <- getCellCORange(cellBarcode = "BC1",
                            co_count = s1_counts)
}
\author{
Ruqian Lyu
}
