% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reformat-geno-mt.R
\name{.label_gt}
\alias{.label_gt}
\title{`label_gt` for changing genotypes in alleles format to labels}
\usage{
.label_gt(s_gt, ref, alt, failed = "Fail")
}
\arguments{
\item{s_gt}{s_gt, a vector of genotypes for one sample across markers}

\item{ref}{ref, a vector of genotypes for reference strain across markers}

\item{alt}{alt, a vector of genotypes for alternative strain across markers}

\item{failed}{what was used for encoding failed genotype calling such as "Fail" in example}
}
\value{
a vector of labels \code{Homo_ref, Homo_alt, Het} indicating the progeny's
genotypes across markers
}
\description{
It turns a vector of Genotypes to a vector of Labels consist of
`Homo_ref`, `Homo_alt`, and `Het` given the known genotypes for reference
and alternative strains.
}
\details{
This function takes the a sample's genotype across each SNP marker in alleles
and compare with genotypes of in-bred reference and alternative strains to.
If the sample's genotype for a particular SNP marker is the same with the
reference strain, it is labelled as Homo_ref \code{homogeneous reference} for
a particular SNP marker; if the sample's genotype is the same with the
alternative strain it is labelled as Homo_alt \code{homogeneous alternative}
for a particular SNP marker; if the sample's genotype is heterozygous then it
is labeled as Het \code{heterozygous} for this particular genotypes. If it
does not fall in any of the three cases, it is labelled as the string
specified by the argument `missing`.

Note that the wrong/failed genotype is labelled as the string in `missing`
after this function.
If there is a different label for failed genotype, provide the label using
the `missing` argument.
}
\author{
Ruqian Lyu
}
\keyword{internal}
