% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal-genetic-dist.R
\name{calGeneticDist}
\alias{calGeneticDist}
\alias{calGeneticDist,GRanges,missing,ANY,ANY,missing-method}
\alias{calGeneticDist,GRanges,numeric,ANY,ANY,missing-method}
\alias{calGeneticDist,GRanges,missing,ANY,ANY,character-method}
\alias{calGeneticDist,GRanges,numeric,ANY,ANY,character-method}
\alias{calGeneticDist,RangedSummarizedExperiment,missing,ANY,ANY,missing-method}
\alias{calGeneticDist,RangedSummarizedExperiment,missing,ANY,ANY,character-method}
\alias{calGeneticDist,RangedSummarizedExperiment,numeric,ANY,ANY,character-method}
\alias{calGeneticDist,RangedSummarizedExperiment,numeric,ANY,ANY,missing-method}
\title{calGeneticDist}
\usage{
calGeneticDist(
  co_count,
  bin_size = NULL,
  mapping_fun = "k",
  ref_genome = "mm10",
  group_by = NULL,
  chrom_info = NULL
)

\S4method{calGeneticDist}{GRanges,missing,ANY,ANY,missing}(
  co_count,
  bin_size = NULL,
  mapping_fun = "k",
  ref_genome = "mm10",
  group_by = NULL,
  chrom_info = NULL
)

\S4method{calGeneticDist}{GRanges,numeric,ANY,ANY,missing}(
  co_count,
  bin_size = NULL,
  mapping_fun = "k",
  ref_genome = "mm10",
  group_by = NULL,
  chrom_info = NULL
)

\S4method{calGeneticDist}{GRanges,missing,ANY,ANY,character}(
  co_count,
  bin_size = NULL,
  mapping_fun = "k",
  ref_genome = "mm10",
  group_by = NULL,
  chrom_info = NULL
)

\S4method{calGeneticDist}{GRanges,numeric,ANY,ANY,character}(
  co_count,
  bin_size = NULL,
  mapping_fun = "k",
  ref_genome = "mm10",
  group_by = NULL,
  chrom_info = NULL
)

\S4method{calGeneticDist}{RangedSummarizedExperiment,missing,ANY,ANY,missing}(
  co_count,
  bin_size = NULL,
  mapping_fun = "k",
  ref_genome = "mm10",
  group_by = NULL,
  chrom_info = NULL
)

\S4method{calGeneticDist}{RangedSummarizedExperiment,missing,ANY,ANY,character}(
  co_count,
  bin_size = NULL,
  mapping_fun = "k",
  ref_genome = "mm10",
  group_by = NULL,
  chrom_info = NULL
)

\S4method{calGeneticDist}{RangedSummarizedExperiment,numeric,ANY,ANY,character}(
  co_count,
  bin_size = NULL,
  mapping_fun = "k",
  ref_genome = "mm10",
  group_by = NULL,
  chrom_info = NULL
)

\S4method{calGeneticDist}{RangedSummarizedExperiment,numeric,ANY,ANY,missing}(
  co_count,
  bin_size = NULL,
  mapping_fun = "k",
  ref_genome = "mm10",
  group_by = NULL,
  chrom_info = NULL
)
}
\arguments{
\item{co_count}{GRange or RangedSummarizedExperiment object, returned by \code{countCO}}

\item{bin_size}{The binning size for grouping marker intervals into bins. If not supplied,the
orginial marker intervals are returned with converted genetic distancens
based on recombination rate}

\item{mapping_fun}{The mapping function to use, can be one of "k" or "h" (kosambi or haldane)}

\item{ref_genome}{The reference genome name. It is used to fetch the chromosome size
information from UCSC database.}

\item{group_by, }{character vector contains the unique prefix of sample names
that are used for defining different sample groups. Or the column name in
colData(co_count) that specify the group factor. If missing all samples are
assumed to be from one group}

\item{chrom_info}{A user supplied data.frame containing two columns with column names
chrom and size, describing the chromosome names and lengths if not using
ref_genome from UCSC. If supplied, the `ref_genome` is ignored.}
}
\value{
GRanges object
GRanges for marker intervals or binned intervals with Haldane or Kosambi
centiMorgans
}
\description{
Calculate genetic distances of marker intervals or binned-chromosome
Given whether crossover happens in each marker interval, calculate the
recombination fraction in samples and then derive the Haldane or Kosambi
genetic distances via mapping functions
}
\examples{
data(coCount)
dist_se <- calGeneticDist(coCount)
# dist_se <- calGeneticDist(coCount,group_by="sampleGroup")

}
