% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/homology_detection.R
\name{compare_orthogroups}
\alias{compare_orthogroups}
\title{Compare inferred orthogroups to a reference set}
\usage{
compare_orthogroups(ref_orthogroups = NULL, test_orthogroups = NULL)
}
\arguments{
\item{ref_orthogroups}{Reference orthogroups in a 3-column data frame
with columns \strong{Orthogroup}, \strong{Species}, and \strong{Gene}.
This data frame can be created from the 'Orthogroups.tsv' file
generated by OrthoFinder with the function \code{read_orthogroups()}.}

\item{test_orthogroups}{Test orthogroups that will be compared
to \emph{ref_orthogroups} in the same 3-column data frame format.}
}
\value{
A 2-column data frame with the following variables:
\describe{
\item{Orthogroup}{Character of orthogroup IDs.}
\item{Preserved}{A logical vector of preservation status. It is TRUE if
the orthogroup in the reference set is fully preserved in the test set,
and FALSE otherwise.}
}
}
\description{
Compare inferred orthogroups to a reference set
}
\details{
This function compares a test set of orthogroups to a reference set
and returns which orthogroups in the reference set are fully preserved
in the test set (i.e., identical gene repertoire) and which are not. Species
names (column 2) must be the same between reference and test set. If some
species are not shared between reference and test sets, they will not be
considered for the comparison.
}
\examples{
set.seed(123)
data(og)
og <- og[1:5000, ]
ref <- og
# Shuffle genes to simulate a different set
test <- data.frame(
    Orthogroup = sample(og$Orthogroup, nrow(og), replace = FALSE),
    Species = og$Species,
    Gene = og$Gene
)
comparison <- compare_orthogroups(ref, test)

# Calculating percentage of preservation
sum(comparison$Preserved) / length(comparison$Preserved)
}
