% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genCode-class.R
\docType{class}
\name{genCode-class}
\alias{genCode-class}
\alias{genCode}
\alias{genCode,ANY-method}
\title{An S4 class \code{genCode}}
\usage{
genCode(id_or_name2 = "1", alt.init = TRUE, stop.rm = FALSE)

\S4method{genCode}{ANY}(id_or_name2 = "1", alt.init = TRUE,
  stop.rm = FALSE)
}
\arguments{
\item{id_or_name2}{
    A single string that uniquely identifies the genetic code to extract.
    Should be one of the values in the \code{id} or \code{name2} columns
    of \code{GENETIC_CODE_TABLE}.
  }

\item{alt.init}{logical, whether to use alternative initiation codons.
Default is \code{TRUE}.}

\item{stop.rm}{logical, whether to remove stop codons. Default is
\code{FALSE}.}
}
\value{
A \code{genCode} object.
}
\description{
Object of \code{genCode} class describes the variant of genetic code
to be used in CU calculations.
}
\section{Methods (by generic)}{
\itemize{
\item \code{genCode}: Creates new instances of \code{genCode} class.
}}

\section{Slots}{

\describe{
\item{\code{ctab}}{A \code{data.table} with two colums:
\code{codon} and \code{AA}, amino acid.}

\item{\code{codons}}{A character vector of codons.}

\item{\code{stops}}{A character vector of stop codons. Note that,
if \code{stop.rm} is \code{TRUE}, this will be
an empty vector.}

\item{\code{nostops}}{A character vector of no-stop codons.
If \code{stop.rm} is \code{TRUE}, this will be
equal to the \code{codons} slot.}

\item{\code{cl}}{A list, each element of which is a vector of integers
indicating the positions of synonymous codons for that amino
acid, when codons are ordered alphabetically.}

\item{\code{deg}}{A numeric vector of degeneracies for
alphabetically ordered amino acids.}
}}

