% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodsAccess.R
\docType{methods}
\name{localAssessments,CNVDetectionResult-method}
\alias{localAssessments,CNVDetectionResult-method}
\title{This generic function returns the local assessments, i.e. 
signed individual informative/non-informative calls,
of a CNV detection method stored in an instance of 
\code{\link{CNVDetectionResult-class}}. For other CNV detection methods
this can be (log-) ratios or z-scores.}
\usage{
\S4method{localAssessments}{CNVDetectionResult}(object)
}
\arguments{
\item{object}{An instance of "CNVDetectionResult"}
}
\value{
\code{localAssessments} returns a "GRanges" object containing
the local assessments.
}
\description{
This generic function returns the local assessments, i.e. 
signed individual informative/non-informative calls,
of a CNV detection method stored in an instance of 
\code{\link{CNVDetectionResult-class}}. For other CNV detection methods
this can be (log-) ratios or z-scores.
}
\examples{
data(cn.mops)
r <- cn.mops(X[1:100,1:5])
localAssessments(r)
}
\author{
Guenter Klambauer \email{klambauer@bioinf.jku.at}
}
