% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/io.R
\name{read.gctx.meta}
\alias{read.gctx.meta}
\alias{read_gctx_meta}
\title{Parse row or column metadata from GCTX files}
\usage{
read.gctx.meta(...)

read_gctx_meta(gctx_path, dim = "row", ids = NULL)
}
\arguments{
\item{...}{arguments passed on to \code{read_gctx_meta}}

\item{gctx_path}{the path to the GCTX file}

\item{dim}{which metadata to read (row or column)}

\item{ids}{a character vector of a subset of row/column ids
for which to read the metadata}
}
\value{
a \code{data.frame} of metadata
}
\description{
Parse row or column metadata from GCTX files
}
\examples{
gct_file <- system.file("extdata", "modzs_n25x50.gctx", package="cmapR") 
# row meta
row_meta <- read_gctx_meta(gct_file)
str(row_meta)
# column meta
col_meta <- read_gctx_meta(gct_file, dim="column")
str(col_meta)
# now for only the first 10 ids
col_meta_first10 <- read_gctx_meta(gct_file, dim="column",
ids=col_meta$id[1:10])
str(col_meta_first10)

}
\seealso{
Other GCTX parsing functions: 
\code{\link{GCT}},
\code{\link{append.dim}()},
\code{\link{fix.datatypes}()},
\code{\link{parse.gctx}()},
\code{\link{process_ids}()},
\code{\link{read.gctx.ids}()},
\code{\link{write.gctx.meta}()},
\code{\link{write.gctx}()},
\code{\link{write.gct}()}
}
\concept{GCTX parsing functions}
