% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GCT.R
\name{meta}
\alias{meta}
\alias{meta,GCT-method}
\alias{meta<-}
\alias{meta<-,GCT-method}
\title{Extract the or set metadata of a GCT object}
\usage{
meta(g, dimension = "row")

\S4method{meta}{GCT}(g, dimension = "row")

meta(g, dimension = "row") <- value

\S4method{meta}{GCT}(g, dimension = "row") <- value
}
\arguments{
\item{g}{the GCT object}

\item{dimension}{the dimension to extract/update ['row' or 'column']}

\item{value}{a data.frame}
}
\value{
a data.frame
}
\description{
Extract the or set metadata of a GCT object
}
\examples{
# extract rdesc
rdesc <- meta(ds)
# extract cdesc
cdesc <- meta(ds, dim="column")
# set rdesc
meta(ds) <- data.frame(x=sample(letters, nrow(rdesc), replace=TRUE))
# set cdesc
meta(ds, dim="column") <- data.frame(x=sample(letters, nrow(cdesc),
  replace=TRUE))
}
\seealso{
Other GCT accessor methods: 
\code{\link{ids}()},
\code{\link{mat}()}
}
\concept{GCT accessor methods}
