% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{clustify}
\alias{clustify}
\alias{clustify.default}
\alias{clustify.Seurat}
\alias{clustify.SingleCellExperiment}
\title{Compare scRNA-seq data to reference data.}
\usage{
clustify(input, ...)

\method{clustify}{default}(
  input,
  ref_mat,
  metadata = NULL,
  cluster_col = NULL,
  query_genes = NULL,
  n_genes = 1000,
  per_cell = FALSE,
  n_perm = 0,
  compute_method = "spearman",
  pseudobulk_method = "mean",
  verbose = TRUE,
  lookuptable = NULL,
  rm0 = FALSE,
  obj_out = TRUE,
  seurat_out = obj_out,
  vec_out = FALSE,
  rename_prefix = NULL,
  threshold = "auto",
  low_threshold_cell = 0,
  exclude_genes = c(),
  if_log = TRUE,
  organism = "hsapiens",
  plot_name = NULL,
  rds_name = NULL,
  expand_unassigned = FALSE,
  ...
)

\method{clustify}{Seurat}(
  input,
  ref_mat,
  cluster_col = NULL,
  query_genes = NULL,
  n_genes = 1000,
  per_cell = FALSE,
  n_perm = 0,
  compute_method = "spearman",
  pseudobulk_method = "mean",
  use_var_genes = TRUE,
  dr = "umap",
  obj_out = TRUE,
  seurat_out = obj_out,
  vec_out = FALSE,
  threshold = "auto",
  verbose = TRUE,
  rm0 = FALSE,
  rename_prefix = NULL,
  exclude_genes = c(),
  metadata = NULL,
  organism = "hsapiens",
  plot_name = NULL,
  rds_name = NULL,
  expand_unassigned = FALSE,
  ...
)

\method{clustify}{SingleCellExperiment}(
  input,
  ref_mat,
  cluster_col = NULL,
  query_genes = NULL,
  per_cell = FALSE,
  n_perm = 0,
  compute_method = "spearman",
  pseudobulk_method = "mean",
  use_var_genes = TRUE,
  dr = "umap",
  obj_out = TRUE,
  seurat_out = obj_out,
  vec_out = FALSE,
  threshold = "auto",
  verbose = TRUE,
  rm0 = FALSE,
  rename_prefix = NULL,
  exclude_genes = c(),
  metadata = NULL,
  organism = "hsapiens",
  plot_name = NULL,
  rds_name = NULL,
  expand_unassigned = FALSE,
  ...
)
}
\arguments{
\item{input}{single-cell expression matrix or Seurat object}

\item{...}{additional arguments to pass to compute_method function}

\item{ref_mat}{reference expression matrix}

\item{metadata}{cell cluster assignments,
supplied as a vector or data.frame.
If data.frame is supplied then \code{cluster_col} needs to be set.
Not required if running correlation per cell.}

\item{cluster_col}{column in metadata that contains cluster ids per cell.
Will default to first column of metadata if not supplied.
Not required if running correlation per cell.}

\item{query_genes}{A vector of genes of interest to compare. If NULL, then
common genes between the expr_mat and ref_mat
will be used for comparision.}

\item{n_genes}{number of genes limit for Seurat variable genes, by default 1000,
set to 0 to use all variable genes (generally not recommended)}

\item{per_cell}{if true run per cell, otherwise per cluster.}

\item{n_perm}{number of permutations, set to 0 by default}

\item{compute_method}{method(s) for computing similarity scores}

\item{pseudobulk_method}{method used for summarizing clusters, options are mean (default), median, truncate (10\% truncated mean), or trimean, max, min}

\item{verbose}{whether to report certain variables chosen and steps}

\item{lookuptable}{if not supplied, will look in built-in table
for object parsing}

\item{rm0}{consider 0 as missing data, recommended for per_cell}

\item{obj_out}{whether to output object instead of cor matrix}

\item{seurat_out}{output cor matrix or called seurat object
(deprecated, use obj_out instead)}

\item{vec_out}{only output a result vector in the same order as metadata}

\item{rename_prefix}{prefix to add to type and r column names}

\item{threshold}{identity calling minimum correlation score threshold,
only used when obj_out = TRUE}

\item{low_threshold_cell}{option to remove clusters with too few cells}

\item{exclude_genes}{a vector of gene names to throw out of query}

\item{if_log}{input data is natural log,
averaging will be done on unlogged data}

\item{organism}{for GO term analysis, organism name: human - 'hsapiens', mouse - 'mmusculus'}

\item{plot_name}{name for saved pdf, if NULL then no file is written (default)}

\item{rds_name}{name for saved rds of rank_diff, if NULL then no file is written (default)}

\item{expand_unassigned}{test all ref clusters for unassigned results}

\item{use_var_genes}{if providing a seurat object, use the variable genes
(stored in seurat_object@var.genes) as the query_genes.}

\item{dr}{stored dimension reduction}
}
\value{
single cell object with identity assigned in metadata,
or matrix of correlation values, clusters from input as row names, cell
types from ref_mat as column names
}
\description{
Compare scRNA-seq data to reference data.
}
\examples{
# Annotate a matrix and metadata
clustify(
    input = pbmc_matrix_small,
    metadata = pbmc_meta,
    ref_mat = cbmc_ref,
    query_genes = pbmc_vargenes,
    cluster_col = "RNA_snn_res.0.5",
    verbose = TRUE
)

# Annotate using a different method
clustify(
    input = pbmc_matrix_small,
    metadata = pbmc_meta,
    ref_mat = cbmc_ref,
    query_genes = pbmc_vargenes,
    cluster_col = "RNA_snn_res.0.5",
    compute_method = "cosine"
)

# Annotate a SingleCellExperiment object
sce <- sce_pbmc()
clustify(
    sce,
    cbmc_ref,
    cluster_col = "clusters",
    obj_out = TRUE,
    per_cell = FALSE,
    dr = "umap"
)

# Annotate a Seurat object
so <- so_pbmc()
clustify(
    so,
    cbmc_ref,
    cluster_col = "seurat_clusters",
    obj_out = TRUE,
    per_cell = FALSE,
    dr = "umap"
)

# Annotate (and return) a Seurat object per-cell
clustify(
    input = so,
    ref_mat = cbmc_ref,
    cluster_col = "seurat_clusters",
    obj_out = TRUE,
    per_cell = TRUE,
    dr = "umap"
)
}
