% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enricher.R
\name{GSEA}
\alias{GSEA}
\title{GSEA}
\usage{
GSEA(
  geneList,
  exponent = 1,
  minGSSize = 10,
  maxGSSize = 500,
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  gson = NULL,
  TERM2GENE,
  TERM2NAME = NA,
  verbose = TRUE,
  nPerm = 1000,
  method = "multilevel",
  adaptive = FALSE,
  minPerm = 101,
  maxPerm = 1e+05,
  pvalThreshold = 0.1,
  ...
)
}
\arguments{
\item{geneList}{order ranked geneList}

\item{exponent}{weight of each step}

\item{minGSSize}{minimal size of each geneSet for analyzing}

\item{maxGSSize}{maximal size of genes annotated for testing}

\item{pvalueCutoff}{adjusted pvalue cutoff}

\item{pAdjustMethod}{one of "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none"}

\item{gson}{a GSON object, if not NULL, use it as annotation data.}

\item{TERM2GENE}{user input annotation of TERM TO GENE mapping, a data.frame of 2 column with term and gene.
Only used when gson is NULL.}

\item{TERM2NAME}{user input of TERM TO NAME mapping, a data.frame of 2 column with term and name.
Only used when gson is NULL.}

\item{verbose}{logical}

\item{nPerm}{The number of permutations.}

\item{method}{method of calculating the pvalue, one of "multilevel", "monte carlo" and "fgsea"}

\item{adaptive}{logical, whether to use adaptive method for calculating pvalue}

\item{minPerm}{minimal number of permutations for adaptive method}

\item{maxPerm}{maximal number of permutations for adaptive method}

\item{pvalThreshold}{pvalue threshold for adaptive method}

\item{...}{other parameter}
}
\value{
gseaResult object
}
\description{
a universal gene set enrichment analysis tools
}
\author{
Guangchuang Yu \url{https://yulab-smu.top}
}
