% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateObject.R
\name{updateObject}
\alias{updateObject}
\alias{updateObject,ClusterExperiment-method}
\title{Update old ClusterExperiment object to current class definition}
\usage{
\S4method{updateObject}{ClusterExperiment}(object, checkTransformAndAssay = FALSE, ..., verbose = FALSE)
}
\arguments{
\item{object}{a \code{ClusterExperiment} (or \code{clusterExperiment} from 
older versions). Must have at a minimum a slot \code{clusterMatrix}.}

\item{checkTransformAndAssay}{logical. Whether to check the content of the
assay and given transformation function for whether they are valid.}

\item{...}{
    Additional arguments, for use in specific \code{updateObject}
    methods.
  }

\item{verbose}{
    \code{TRUE} or \code{FALSE}, indicating whether information about
    the update should be reported. Use \code{\link[base]{message}} to
    report this information.
  }
}
\value{
A valid \code{ClusterExperiment} object based on the current 
  definition of ClusterExperiment.
}
\description{
This function updates ClusterExperiment objects from previous
  versions of package into the current definition
}
\details{
The function creates a valid \code{ClusterExperiment} object by 
  adding the default values of missing slots. It does so by calling the 
  \code{\link{ClusterExperiment}} function, which imputs default (empty) 
  values for missing slots.

The object is required to have minimal components to be updated. 
  Specifically, it must have all the required elements of a Summarized 
  Experiment as well as the basic slots of a ClusterExperiment object which 
  have not changed over time. These are: \code{clusterMatrix},
  \code{primaryIndex}, \code{clusterInfo}, \code{transformation}, 
  \code{clusterTypes}, \code{clusterLegend}, \code{orderSamples}.

If \emph{any} of the dendrogram-related slots are missing, ALL of 
  the dendrogram \emph{and} merge related slots will be cleared to default 
  values. Similarly, if \emph{any} of the merge-related slots are missing, 
  ALL of the merge-related slots will be cleared to the default values.

Cluster and Sample dendrograms of the class \code{dendrogram} will
  be updated to the \code{\link[phylobase]{phylo4d}} class now used in
  \code{ClusterExperiment} objects; the merge information on these nodes will
  be updated to have the correct format (i.e. match to the internal node id
  names in the new dendrogram). The previous identification of nodes that was
  previously created internally by plotDendrogram and the merging (labels in
  the form of 'Node1','Node2'), will be kept as
  \code{\link[phylobase]{nodeLabels}} in the new dendrogram class.

The function currently only works for object of 
  \code{ClusterExperiment}, not the older name \code{clusterExperiment}.
}
\seealso{
\code{\link{ClusterExperiment}}
}
