% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02.getContextSequences.R
\name{getContextSequences}
\alias{getContextSequences}
\title{Retrieve upstream and downstream sequences}
\usage{
getContextSequences(peaks, upstream = 40L, downstream = 30L, genome)
}
\arguments{
\item{peaks}{An object of GRanges representing pA sites}

\item{upstream}{An integer(1) vector, length of upstream sequence of pA 
sites, including pA site.}

\item{downstream}{An integer(1) vector, length of downstream sequences of 
pA sites}

\item{genome}{An object of BSgenome.}
}
\value{
A data.frame containing sequences upstream and downstream pA sites:
\describe{
    \item{upstream.seq}{sequence upstream pA site, including pA site}
    \item{downstream.seq}{sequence downstream pA site}
}
}
\description{
Retrieve upstream and downstream sequences of pA sites from a BSgenome object
based on a GRanges object
}
\examples{
library(BSgenome.Drerio.UCSC.danRer7)
testFile <- system.file("extdata", "test.bed",
                        package = "cleanUpdTSeq")
peaks <- BED6WithSeq2GRangesSeq(file = testFile, 
                               skip = 1L, withSeq = FALSE)
peaks_seq <- getContextSequences(peaks, 
                                 upstream = 40L, 
                                 downstream = 30L,
                                 genome = Drerio) 
                                                        
}
\author{
Haibo Liu
}
