% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPlots.R
\name{plotHostGenes}
\alias{plotHostGenes}
\title{Plot circRNA host genes}
\usage{
plotHostGenes(annotatedBSJs, title = "")
}
\arguments{
\item{annotatedBSJs}{A data frame with the annotated back-spliced junctions.
This data frame can be generated with \code{\link{annotateBSJs}}.}

\item{title}{A character string specifying the title of the plot.}
}
\value{
A ggplot object.
}
\description{
The function plotHostGenes() generates a bar chart showing the
no. of circRNAs produced from each the circRNA host gene.
}
\examples{
# Load data frame containing detected back-spliced junctions
data("mergedBSJunctions")

# Load short version of the gencode v19 annotation file
data("gtf")

# Annotate the first 10 back-spliced junctions
annotatedBSJs <- annotateBSJs(mergedBSJunctions[1:10, ], gtf)

# Plot
p <- plotHostGenes(annotatedBSJs, title = "")
p

}
