% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPlots.R
\name{plotExBetweenBSEs}
\alias{plotExBetweenBSEs}
\title{Plot exons between back-spliced junctions}
\usage{
plotExBetweenBSEs(annotatedBSJs, title = "")
}
\arguments{
\item{annotatedBSJs}{A data frame with the annotated back-spliced junctions.
This data frame can be generated with \code{\link{annotateBSJs}}.}

\item{title}{A character string specifying the title of the plot.}
}
\value{
A ggplot object.
}
\description{
The function plotExBetweenBSEs() generates a bar chart showing
the no. of exons in between the back-spliced junctions.
}
\examples{
# Load data frame containing detected back-spliced junctions
data("mergedBSJunctions")

# Load short version of the gencode v19 annotation file
data("gtf")

# Annotate the first 10 back-spliced junctions
annotatedBSJs <- annotateBSJs(mergedBSJunctions[1:10, ], gtf)

# Plot
p <- plotExBetweenBSEs(annotatedBSJs, title = "")
p


}
