% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_circle.R
\name{plot_circle}
\alias{plot_circle}
\title{Create a circle plot of the given fusions.}
\usage{
plot_circle(fusion_list)
}
\arguments{
\item{fusion_list}{A list of Fusion objects.}
}
\value{
Creates a circle plot.
}
\description{
This function takes a list of Fusion objects and creates a circle plot
indicating which chromosomes the fusion genes in the list consists of.
}
\details{
Note that only a limited number of gene names can be shown in the circle plot
due to the limited resolution of the plot. RCircos will automatically limit
the number of gene names shown if there are too many.
}
\examples{
defuse833ke <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuse833ke, "hg19", 3)
# Temporary file to store the plot
pngFilename <- tempfile(
  pattern = "circlePlot",
  fileext = ".png",
  tmpdir = tempdir())
# Open device
png(pngFilename, width = 1000, height = 750)
# Plot!
plot_circle(fusions)
# Close device
dev.off()

}
