% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_starfusion.R
\name{import_starfusion}
\alias{import_starfusion}
\title{Import results from a STAR-Fusion run into a list of Fusion objects.}
\usage{
import_starfusion(filename, genome_version, limit)
}
\arguments{
\item{filename}{Filename for the STAR-Fusion
star-fusion.fusion_candidates.final.abridged results file.}

\item{genome_version}{Which genome was used in mapping (hg19, hg38, etc.).}

\item{limit}{A limit on how many lines to read.}
}
\value{
A list of Fusion objects.
}
\description{
A function that imports the results from a STAR-Fusion run, typically from
a star-fusion.fusion_candidates.final.abridged file, into a list of Fusion
objects.
}
\examples{
starfusionData <- system.file(
  "extdata",
  "star-fusion.fusion_candidates.final.abridged.txt",
  package = "chimeraviz")
fusions <- import_starfusion(starfusionData, "hg19", 3)
# This should import a list of 3 fusions described in Fusion objects.

}
