% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_prada.R
\name{import_prada}
\alias{import_prada}
\title{Import results from a PRADA run into a list of Fusion objects.}
\usage{
import_prada(filename, genome_version, limit)
}
\arguments{
\item{filename}{Filename for the PRADA results file.}

\item{genome_version}{Which genome was used in mapping (hg19, hg38, etc.).}

\item{limit}{A limit on how many lines to read.}
}
\value{
A list of Fusion objects.
}
\description{
A function that imports the results from a PRADA run into a list of Fusion
objects.
}
\examples{
pradaData <- system.file(
  "extdata",
  "PRADA.acc.fusion.fq.TAF.tsv",
  package = "chimeraviz")
fusions <- import_prada(pradaData, "hg19", 3)
# This should import a list of 3 fusions described in Fusion objects.

}
