% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{fetch_reads_from_fastq}
\alias{fetch_reads_from_fastq}
\title{Fetch reads from fastq files}
\usage{
fetch_reads_from_fastq(
  reads,
  fastq_file_in1,
  fastq_file_in2,
  fastq_file_out1,
  fastq_file_out2
)
}
\arguments{
\item{reads}{List of read IDs that is to be fetched.}

\item{fastq_file_in1}{First fastq file to search in.}

\item{fastq_file_in2}{Second fastq file to seach in.}

\item{fastq_file_out1}{First fastq file with results.}

\item{fastq_file_out2}{Second fastq file with results.}
}
\value{
The files fastqFileOut1 and fastqFileOut2 populated with the
specified reads.
}
\description{
This function will fetch read sequences from fastq files and put them into
new fastq files.
}
\details{
Note: This function runs (read only) bash commands on your system. Therefore
the function will only work on a unix system.
}
\examples{
\dontrun{
# fastq files that has the supporting reads
fastq1 <- system.file("extdata", "reads.1.fq", package="chimeraviz")
fastq2 <- system.file("extdata", "reads.2.fq", package="chimeraviz")
# Which read ids to extract
reads <- c(
  "13422259", "19375605", "29755061",
  "31632876", "32141428", "33857245")
# Extract the actual reads and put them in the tmp files "fastqFileOut1" and
# "fastqFileOut2"
fastqFileOut1 <- tempfile(pattern = "fq1", tmpdir = tempdir())
fastqFileOut2 <- tempfile(pattern = "fq2", tmpdir = tempdir())
fetch_reads_from_fastq(reads, fastq1, fastq2,
    fastqFileOut1, fastqFileOut2)
# We now have the reads supporting fusion 5267 in the two files.
}

}
