% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{decide_transcript_category}
\alias{decide_transcript_category}
\title{Retrieves transcripts for partner genes in a Fusion object using Ensembldb}
\usage{
decide_transcript_category(gr, fusion)
}
\arguments{
\item{gr}{The GRanges object containing the transcript to be checked.}

\item{fusion}{The fusion object used to check the transcript.}
}
\value{
Either "exonBoundary", "withinExon", "withinIntron", or "intergenic"
depending on where in the transcript the breakpoint hits.
}
\description{
This function will check where in the transcript (the GRanges object) the
fusion breakpoint is located, and return either "exonBoundary", "withinExon",
"withinIntron", or "intergenic".
}
\examples{
# Load fusion data and choose a fusion object:
defuseData <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuseData, "hg19", 1)
fusion <- get_fusion_by_id(fusions, 5267)
# Create edb object
edbSqliteFile <- system.file(
  "extdata",
  "Homo_sapiens.GRCh37.74.sqlite",
  package="chimeraviz")
edb <- ensembldb::EnsDb(edbSqliteFile)
# Get all exons for all transcripts in the genes in the fusion transcript
allTranscripts <- ensembldb::exonsBy(
  edb,
  filter = list(
    AnnotationFilter::GeneIdFilter(
      c(
        partner_gene_ensembl_id(upstream_partner_gene(fusion)),
        partner_gene_ensembl_id(downstream_partner_gene(fusion))))),
  columns = c(
    "gene_id",
    "gene_name",
    "tx_id",
    "tx_cds_seq_start",
    "tx_cds_seq_end",
    "exon_id"))
# Extract one of the GRanges objects
gr <- allTranscripts[[1]]
# Check where in the transcript the fusion breakpoint hits
decide_transcript_category(gr, fusion)
# "exonBoundary"
# Check another case
gr <- allTranscripts[[3]]
decide_transcript_category(gr, fusion)
# "withinIntron"

}
