% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{add_fusion_reads_alignment}
\alias{add_fusion_reads_alignment}
\title{Add fusion reads alignment to fusion object}
\usage{
add_fusion_reads_alignment(fusion, bamfile)
}
\arguments{
\item{fusion}{The fusion object to add a genomic alignment to.}

\item{bamfile}{The bam file containing the fusion reads plotted to the fusion
sequence.}
}
\value{
An updated fusion object with fusion@fusion_reads_alignment set.
}
\description{
This function lets you add a fusion read alignment file to a fusion object.
If you've mapped the reads supporting a fusion against the fusion junction
sequence, and have the resulting bamfile, use this function to add the
information (as a Gviz::GAlignmentPairs object) to the fusion object.
}
\examples{
# Load data
defuse833ke <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuse833ke, "hg19", 1)
# Find the specific fusion we have aligned reads for
fusion <- get_fusion_by_id(fusions, 5267)
# Get reference to the bamfile with the alignment data
bamfile5267 <- system.file(
  "extdata",
  "5267readsAligned.bam",
  package="chimeraviz")
# Add the bam file of aligned fusion reads to the fusion object
fusion <- add_fusion_reads_alignment(fusion, bamfile5267)

}
