% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validate}
\alias{validate}
\title{Validate an artifact}
\usage{
validate(path, name)
}
\arguments{
\item{path}{String containing the path to the HDF5 file.}

\item{name}{String containing the name of the delayed object inside the file.}
}
\value{
\code{NULL} if there are no problems, otherwise an error is raised.
}
\description{
Validate the delayed objects inside a HDF5 file.
This is automatically run at the end of every \code{\link{saveDelayed}} call to check the integrity of the saved files.
See \url{https://artifactdb.github.io/chihaya/} for more details.
}
\examples{
X <- DelayedArray(matrix(runif(100), ncol=20))
Y <- X[1:2,3:5]
temp <- tempfile(fileext=".h5")
saveDelayed(Y, temp)
validate(temp, "delayed")

}
\seealso{
See \url{https://artifactdb.github.io/chihaya/} for the specification.
}
\author{
Aaron Lun
}
