% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveDelayed.R
\name{saveDelayed}
\alias{saveDelayed}
\title{Save a DelayedMatrix}
\usage{
saveDelayed(x, file, path = "delayed")
}
\arguments{
\item{x}{A \linkS4class{DelayedArray} object.}

\item{file}{String containing a path to a HDF5 file.
This will be created if it does not yet exist.}

\item{path}{String containing a path inside a HDF5 file.
This should not already exist, though any parent groups should already be constructed.}
}
\value{
The contents of \code{x} are written to file and a \code{NULL} is invisibly returned.
}
\description{
Save a \linkS4class{DelayedMatrix} object to a location within a HDF5 file.
}
\details{
See the various \code{\link{saveDelayedObject}} methods for how each suite of delayed operations is handled.
Also see \url{https://artifactdb.github.io/chihaya/} for more details on the data layout inside the HDF5 file.
}
\examples{
library(HDF5Array)
X <- rsparsematrix(100, 20, 0.1)
Y <- DelayedArray(X)
Z <- log2(Y + 1)

temp <- tempfile(fileext=".h5")
saveDelayed(Z, temp)
rhdf5::h5ls(temp)

}
\author{
Aaron Lun
}
