% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadDelayed.R
\name{loadDelayed}
\alias{loadDelayed}
\title{Load a DelayedMatrix}
\usage{
loadDelayed(file, path = "delayed")
}
\arguments{
\item{file}{String containing a path to a HDF5 file.}

\item{path}{String containing a path inside a HDF5 file containing the DelayedMatrix.}
}
\value{
A \linkS4class{DelayedMatrix} containing the contents at \code{path}.
}
\description{
Load a \linkS4class{DelayedMatrix} object from a location within a HDF5 file.
}
\examples{
library(HDF5Array)
X <- rsparsematrix(100, 20, 0.1)
Y <- DelayedArray(X)
Z <- log2(Y + 1)

temp <- tempfile(fileext=".h5")
saveDelayed(Z, temp)
loadDelayed(temp)

}
\seealso{
\code{\link{knownOperations}} and \code{\link{knownArrays}}, to modify the loading procedure.
}
\author{
Aaron Lun
}
