% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateMarkerParam.R
\name{GenerateMarkerParam}
\alias{GenerateMarkerParam}
\title{Generate the methylation pattern of markers}
\usage{
GenerateMarkerParam(x, sample.types, marker.names, output.file = "")
}
\arguments{
\item{x}{a list of methylation levels (e.g., beta values), 
where each row is a sample and each column is a marker.}

\item{sample.types}{a vector of sample types (e.g., tumor or normal, 
tissue types) corresponding to the rows of the list.}

\item{marker.names}{a vector of marker names corresponding to the 
columns of the list.}

\item{output.file}{a character string naming the output file. 
Default is "", which means the output will not be written into a file.}
}
\value{
a list containing the paired shape parameters of 
beta distributions for markers and/or written to an output file.
}
\description{
Output paired shape parameters of beta distributions for methylation markers.
}
\examples{
## input files
demo.dir <- system.file("data", package="cfTools")
methLevel <- read.table(file.path(demo.dir, "beta_matrix.txt.gz"), 
row.names=1, header = TRUE)
sampleTypes <- read.table(file.path(demo.dir, "sample_type.txt.gz"), 
row.names=1, header = TRUE)$sampleType
markerNames <- read.table(file.path(demo.dir, "marker_index.txt.gz"), 
row.names=1, header = TRUE)$markerIndex

output <- GenerateMarkerParam(methLevel, sampleTypes, markerNames)

}
