% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{DiRatioPlot}
\alias{DiRatioPlot}
\title{Directionality Ratio plots}
\usage{
DiRatioPlot(object, TimeInterval = 10, export = FALSE, ExpName = NULL)
}
\arguments{
\item{object}{\code{CellMig} class object, which is a list
of data frames resulted from the PreProcessing.}

\item{TimeInterval}{A numeric value of the time elapsed between
successive frames in the time-lapse stack.}

\item{export}{if `TRUE` (default), exports plot to JPG file}

\item{ExpName}{string, name of the experiment. Can be NULL}
}
\value{
Directionality Ratio plots
}
\description{
Directionality Ratio is the displacement divided
by the total length of the total path distance, where displacement
is the straightline length between the start point and the endpoint
of the migration trajectory,
}
\details{
Directionality Ratio
}
\examples{
rmTD <- get(data(preProcCellMig))
DiRatioPlot(object=rmTD, export=FALSE)


}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Salim Ghannoum \email{salim.ghannoum@medisin.uio.no}
}
